;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: QP1B.inc
;;   Version: 2.3, Updated on 2004/07/29 at 17:41:18
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the Counter8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for QP1B API's.
;--------------------------------------------------

QP1B_CONTROL_REG_START_BIT:                equ 0x01    ; Control register start bit
QP1B_INT_REG:                              equ 0x0df
QP1B_INT_MASK:                             equ 0x80


;--------------------------------------------------
; Constants for QP1B user defined values
;--------------------------------------------------

QP1B_PERIOD:                               equ 0xff
QP1B_COMPARE_VALUE:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for QP1B
;--------------------------------------------------

QP1B_COUNTER_REG:                      equ 0x5c   ; DR0 Counter register
QP1B_PERIOD_REG:                       equ 0x5d   ; DR1 Period register
QP1B_COMPARE_REG:                      equ 0x5e   ; DR2 CompareValue register
QP1B_CONTROL_REG:                      equ 0x5f   ; Control register
QP1B_FUNC_REG:                         equ 0x5c   ; Function register
QP1B_INPUT_REG:                        equ 0x5d   ; Input register
QP1B_OUTPUT_REG:                       equ 0x5e   ; Output register


;--------------------------------------------------
; QP1B Macro 'Functions'
;--------------------------------------------------

   macro QP1B_Start_M
   or    reg[QP1B_CONTROL_REG],  QP1B_CONTROL_REG_START_BIT
   endm

   macro QP1B_Stop_M
   and   reg[QP1B_CONTROL_REG], ~QP1B_CONTROL_REG_START_BIT
   endm

   macro QP1B_EnableInt_M
   M8C_EnableIntMask QP1B_INT_REG, QP1B_INT_MASK
   endm

   macro QP1B_DisableInt_M
   M8C_DisableIntMask QP1B_INT_REG, QP1B_INT_MASK
   endm


; end of file QP1B.inc
